## Installation

### Requirements:
- Python3
- PyTorch 1.1 with CUDA support
- torchvision
- pycocotools
- yacs
- matplotlib
- GCC >= 4.9
- (optional) OpenCV for the webcam demo


### Step-by-step installation

```bash
# first, make sure that your conda is setup properly with the right environment
# for that, check that `which conda`, `which pip` and `which python` points to the
# right path. From a clean conda env, this is what you need to do

conda create --name free_anchor python=3.7
source activate free_anchor

# this installs the right pip and dependencies for the fresh python
conda install ipython

# maskrnn_benchmark and coco api dependencies
pip install ninja yacs cython matplotlib

# pytorch and torchvision
# we give the instructions for CUDA 9.0
conda install pytorch torchvision cudatoolkit=9.0 -c pytorch

# install pycocotools
pip install pycocotools

# install PyTorch maskrcnn-benchmark.
cd path_to_free_anchor
# the following will install the lib with
# symbolic links, so that you can modify
# the files if you want and won't need to
# re-build it
python setup.py build develop

# or if you are on macOS
# MACOSX_DEPLOYMENT_TARGET=10.9 CC=clang CXX=clang++ python setup.py build develop
```
